import java.awt.Choice;
import java.awt.event.*;
import java.util.Vector;

// Referenced classes of package duggelz.jape:
//            DataChangeEvent, DataChangeMixin, FieldView, Structure,
//            DataChangeListener

public class ChoiceView extends Choice
    implements FieldView, ItemListener,KeyListener
{

    public ChoiceView(String fieldName, Vector choices)
    {
        suppressEvents = false;
        modified = false;
        mixin = new DataChangeMixin();
        this.fieldName = fieldName;
        for(int idx = 0; idx < choices.size(); idx++)
            add((String)choices.elementAt(idx));

        addItemListener(this);
        addKeyListener(this);
        feld=choices;
        suche = new String();
        suche = "";
        vergleich = new String();
        vergleich="";
    }

    public void addDataChangeListener(DataChangeListener l)
    {
        mixin.addDataChangeListener(l);
    }

    public void commit(String newValue)
    {
        if(struct != null)
        {
            String oldValue = struct.get(fieldName);
            if(oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue))
            {
                modified = true;
                struct.set(fieldName, newValue);
                fireDataChangeEvent(new DataChangeEvent(this, this.oldValue, newValue));
            }
        }
    }

    public void fireDataChangeEvent(DataChangeEvent e)
    {
        mixin.fireDataChangeEvent(e);
    }

    public String getFieldName()
    {
        return fieldName;
    }

    public String getValue()
    {
        return getSelectedItem();
    }

    public boolean isModified()
    {
        return modified;
    }

    public void itemStateChanged(ItemEvent event)
    {
        if(suppressEvents)
        {
            return;
        } else
        {
            String newValue = getSelectedItem();
            commit(newValue);
            oldValue = newValue;
            return;
        }
    }

    public synchronized void refresh()
    {
        try
        {
            suppressEvents = true;
            String value = null;
            if(struct != null)
                value = struct.get(fieldName);
            if(value != null)
                select(value);
            else
                select(0);
            oldValue = value;
            modified = false;
            suche="";
        }
        finally
        {
            suppressEvents = false;
        }
    }

    public void removeDataChangeListener(DataChangeListener l)
    {
        mixin.removeDataChangeListener(l);
    }

    public void setStruct(Structure struct)
    {
        this.struct = struct;
    }

    public void keyTyped(KeyEvent event)
  {
  }
  public void keyPressed(KeyEvent event)
    {
        if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
            suche = "";
            return;
        }
        ;
        if (event.getKeyCode() == KeyEvent.VK_BACK_SPACE) {
            if (suche.length() > 1)
                suche = suche.substring(0, suche.length() - 1);
            else suche = "";
            return;
        }
        suche = suche + event.getKeyChar();
        suche = suche.toLowerCase();

        for (int idx = 0; idx < feld.size(); idx++) {
            vergleich = feld.elementAt(idx).toString();
            if (suche.length()<vergleich.length())
            {
                vergleich = vergleich.substring(0, suche.length());
            }
            vergleich=vergleich.toLowerCase();
            if (suche.equals(vergleich))
            {
                 this.select(idx);
                 return;
            }
        }
    }
    public void keyReleased(KeyEvent event)
    {
   }

    private boolean suppressEvents;
    private String fieldName;
    private boolean modified;
    private String oldValue;
    private Structure struct;
    private DataChangeMixin mixin;
    private String suche;
    private Vector feld;
    private String vergleich;
    static final long serialVersionUID = 030265;
}
